
// DeinterlacerDlg.h : header file
//

#pragma once
#include "afxwin.h"


// CDeinterlacerDlg dialog
class CDeinterlacerDlg : public CDialogEx
{
// Construction
public:
	CDeinterlacerDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CDeinterlacerDlg)
	enum { IDD = IDD_DEINTERLACER_DIALOG };
	CStatic			m_statWindow;
	CButton		m_btnStart;
	CButton		m_btnStop;
	//}}AFX_DATA

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnBnClickedBtnStart();
	afx_msg void OnBnClickedBtnStop();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	BOOL				GetCurrentDeviceFormat( ULONG * pVideoWidth, ULONG * pVideoHeight, BOOL *  pVideoIsInterleaved, ULONG * pVideoFrameRate,  ULONG * pAudioChannels,  ULONG * pAudioBitsPerSample, ULONG * pAudioSampleFrequency );

	CString				GetWorkingPath( );

public:

	BOOL									m_bSetBuffer;

	DEVICE_HANDLE				m_hVideoDev;										// VIDEO STREAM CAPTURE DEVICE

	DEVICE_HANDLE				m_hVideoSWEncoderDev;						// H264 SOFTWARE ENCODER DEVICE

	DEVICE_HANDLE				m_hAudioDev;										// AUDIO STREAM CAPTURE DEVICE 

	DEVICE_HANDLE				m_hAudioAACEncoderDev;					// AUDIO AAC SOFTWARE ENCODER DEVICE 

	DEVICE_HANDLE				m_hFileRendererDev;								// FILE RENDERER DEVICE

	ULONG								m_nFileRendererRecordState;					// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	DEVICE_HANDLE				m_hDeinterlaceDev;

	BOOL									m_bVideoIsInterleaved;

	HANDLE 							m_hVideoThreadBufferReadyEvent;

	HANDLE								m_hVideoThread;

	ULONG								m_hVideoThreadNumber;

	HANDLE 							m_hAudioThreadBufferReadyEvent;

	HANDLE								m_hAudioThread;

	ULONG								m_hAudioThreadNumber;
};
